import sys
import autograd.numpy as np

class KGauss():

    def __init__(self, sigma2):
        assert sigma2 > 0, 'sigma2 must be > 0'
        self.sigma2 = sigma2

    def eval(self, X1, X2):
        """
        Evaluate the Gaussian kernel on the two 2d numpy arrays.
        Parameters
        ----------
        X1 : n1 x d numpy array
        X2 : n2 x d numpy array
        Return
        ------
        K : a n1 x n2 Gram matrix.
        """
        (n1, d1) = X1.shape
        (n2, d2) = X2.shape
        assert d1==d2, 'Dimensions of the two inputs must be the same'
        D2 = np.sum(X1**2, 1)[:, np.newaxis] - 2*np.dot(X1, X2.T) + np.sum(X2**2, 1)
        K = np.exp(-D2/(2 * self.sigma2**2))
        return K